---
generated_at: 2026-01-27 12:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-Menubar - Render 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/js/Menubar.Render.js` - Renderメニューの実装ファイル（842行）
- E-02: `editor/js/libs/app.js` - APP.Player実装（282行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Video機能は'VideoEncoder' in windowでチェック | E-01 (38行目) | ○ |
| C-02 | Shadingのデフォルトは'solid' | E-01 (114行目) | ○ |
| C-03 | パストレーサーのサンプル数は3〜65536 | E-01 (117-118行目) | ○ |
| C-04 | 画像解像度のデフォルトは1024x1024 | E-01 (141, 146行目) | ○ |
| C-05 | 動画解像度のデフォルトは1024x1024 | E-01 (367, 372行目) | ○ |
| C-06 | 動画FPSのデフォルトは30 | E-01 (375行目) | ○ |
| C-07 | 動画Durationのデフォルトは10秒 | E-01 (386行目) | ○ |
| C-08 | 動画Qualityのデフォルトは'high' | E-01 (400行目) | ○ |
| C-09 | Quality 'low'は2Mbps | E-01 (499行目) | ○ |
| C-10 | Quality 'medium'は5Mbps | E-01 (500行目) | ○ |
| C-11 | Quality 'high'は10Mbps | E-01 (501行目) | ○ |
| C-12 | Quality 'ultra'は20Mbps | E-01 (502行目) | ○ |
| C-13 | 動画コーデックは'avc1.640028' | E-01 (506行目) | ○ |
| C-14 | 動画の幅/高さは偶数に強制される（toDiv2） | E-01 (356-360行目) | ○ |
| C-15 | REALISTICモードはMeshStandardMaterialを要求 | E-01 (173行目) | ○ |
| C-16 | 非対応マテリアル時はalertを表示 | E-01 (188行目) | ○ |
| C-17 | editor.toJSON()でシーンをJSON化 | E-01 (197行目) | ○ |
| C-18 | ObjectLoaderでカメラ/シーンをパース | E-01 (204, 209行目) | ○ |
| C-19 | APP.Playerで動画レンダリングを実行 | E-01 (413行目) | ○ |
| C-20 | createMP4()でMP4ファイルを生成 | E-01 (549行目) | ○ |
| C-21 | formatFileSize()でファイルサイズを表示 | E-01 (551行目) | ○ |
| C-22 | MP4のtimescaleは90000 | E-01 (585行目) | ○ |
| C-23 | VideoFrameはキーフレームを毎秒設定 | E-01 (531行目) | ○ |
| C-24 | 進捗表示は"{samples} / {maxSamples} ( {progress}% )"形式 | E-01 (287行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張についてソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [x] Image/Videoダイアログの入力項目とデフォルト値が正確か
- [x] レンダリング処理フローが正確に記載されているか
- [x] エラー処理（非対応マテリアル等）が正確か
- [x] MP4生成ロジックの概要が正確か
- [x] Quality設定とビットレートの対応が正確か
